/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.runtime.summary.VWWorkItemTable;
import filenet.vw.toolkit.runtime.summary.VWWorkItemTableModel;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWWorkItemPanel
extends JScrollPane
implements ChangeListener {
    private VWTrackerSummaryInfo m_summaryPanel = null;
    private VWWorkItemTableModel m_tableModel = null;
    private VWWorkItemTable m_table = null;
    private VWTrkDataModel m_trackerDataModel = null;
    protected Frame m_parentFrame = null;

    VWWorkItemPanel(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_trackerDataModel = trackerDataModel;
    }

    public void initialize() {
        if (this.m_trackerDataModel == null || this.m_trackerDataModel.getInitState() != 6) {
            return;
        }
        this.m_tableModel = new VWWorkItemTableModel(this.m_trackerDataModel);
        this.m_table = new VWWorkItemTable(this.m_parentFrame, this.m_summaryPanel, this.m_tableModel);
        this.add(this.m_table);
        this.setViewportView(this.m_table);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane && this.m_table != null) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.getSelectedComponent() == this) {
                this.m_table.tabSelected(true);
                this.m_table.updateStatusDetailsDialog();
                this.m_table.updateInformationStackDialog();
            } else {
                this.m_table.tabSelected(false);
            }
        }
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        this.m_parentFrame = null;
        this.m_summaryPanel = null;
        if (this.m_table != null) {
            this.m_table.removeReferences();
            this.m_table = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        this.getViewport().removeAll();
        this.removeAll();
    }
}

